clear *
set mem 2000m

cap program drop jw_lowess
program define jw_lowess
	version 9.2
	syntax varlist (min=2 max=2 numeric) [if]  [, bwidth(real 0.8) GENerate(string) mean]
	marksample touse
	tokenize `varlist'
	local y `1'
	local x `2'
	confirm new var `generate'
	qui gen double `generate'=.
	confirm new var `generate'_stdp
	qui gen double `generate'_stdp=.
	tempvar sample
	qui gen `sample'=1 `if' 
	qui replace `sample' =. if `x'==. | `y'==.
	qui summ `x' if `sample'==1
	local N=r(N)
	local k=int((`bwidth'*`N'-.5)/2)
	sort `sample' `x'
	qui forvalues i=1/`N' {
		local iminus=max(1,`i'-`k')
		local iplus=min(`i'+`k',`N')
		local delta=1.0001*max(`x'[`iplus']-`x'[`i'], `x'[`i']-`x'[`iminus'])
		tempvar wt hat hat_stdp
		gen `wt'=(1-((abs(`x'[`i']-`x')/`delta')^3))^3 if _n>=`iminus' & _n<=`iplus' & `sample'==1
		replace `wt'=0 if `wt'<0
		if "%_mean"~="" {
			reg `y' [aw=`wt'] if `sample'==1
		} 
		else {
			reg `y' `x' [aw=`wt'] if `sample'==1
		}
		predict `hat' 
		predict `hat_stdp', stdp
		replace `generate'=`hat' if `i'==_n
		replace `generate'_stdp=`hat_stdp' `if' & `i'==_n
		drop `hat' `hat_stdp' `wt' 
	}
end


* Margin Graph
use team_data if sample==1, clear
for X in num 0/3: jw_lowess margin diff_blackper if white==X, gen(mr_X) mean bwidth(.4)
for X in num 0/3:	gen ciu_X=mr_X+1.96*mr_X_stdp \ gen cil_X=mr_X-1.96*mr_X_stdp 
global scale=2
for X in num 0/3:	replace ciu_X=min(ciu_X,$scale) if ciu_X~=. \ replace cil_X=max(cil_X,-$scale) if cil_X~=.
graph set eps fontface Times
#delimit ;
for X in num 0 2 3:
	twoway 
		(rarea ciu_X cil_X diff_blackper, sort lcolor(gs14) lwidth(none) fcolor(gs14))
		(line mr_X diff_blackper, sort lcolor(navy) lwidth(medthick))
	if abs(diff_blackper)<.5
	,
	ylabel(, angle(horizontal)) 
	xlabel(-.5 "-50%" -.25 "-25%" 0 "0%" .25 "25%" .5 "50%")
	xtick(.52, notick)
	ylabel(-$scale(1)$scale, format(%9.0f))
	name(margin_X, replace)
	xtitle("")
	ytitle("")
	title("X white referees", ring(0))
	legend(off)
	xsize(10) ysize(7.5) 
;
* Fix "one white referee";
twoway 
	(rarea ciu_1 cil_1 diff_blackper, sort lcolor(gs14) lwidth(none) fcolor(gs14))
	(line mr_1 diff_blackper, sort lcolor(navy) lwidth(medthick))
	if abs(diff_blackper)<.5
,
	ylabel(, angle(horizontal)) 
	xlabel(-.5 "-50%" -.25 "-25%" 0 "0%" .25 "25%" .5 "50%") 
	xtick(.52, notick)
	ylabel(-$scale(1)$scale, format(%9.0f))
	name(margin_1, replace)
	xtitle("")
	ytitle("")
	title("1 white referee", ring(0))
	legend(off)
	xsize(10) ysize(7.5) 
;
#delimit ;
graph set eps fontface Times;
graph combine margin_3 margin_2 margin_1 margin_0,
	b1title("Difference in Racial Composition of Teams: %Black less Opponent %Black")
	b2title("(measured as difference in share of playing time)") 
	l1title("Average Winning Margin: Points for less against")
	imargin(tiny)
	xsize(10) ysize(7.5) 
	saving(Results\Fig1, replace)
;
graph export Results\Fig1.eps, replace;
#delimit cr;

