clear *

cap log close
cap log using logs\Table6.log, replace

set more off
set mem 800m
set matsize 11000 
set maxvar 20000
  
* Table 6
use team_data if sample==1, clear
 
drop if fracwhite==. | home_attend==. | out_cont==.
replace coachid=-999 if coachid==.
replace opp_coachid=-999 if opp_coachid==.

* Col. 1: Observables, opponent observables, plus:
xi i.team, prefix(t_)
xi i.opp_team, prefix(o_)
xi i.year, prefix(yr_) 

* Col. 2: Plus observables*fracwhite, stadium*%black, stadium*%black opponent, team*year, opponent*year
xi i.home_team*blackper, prefix(htb_)
xi i.home_team*opp_blackper, prefix(hoy_)
xi i.team*i.year, prefix(ty_)
xi i.opp_team*i.year, prefix(oy_)

* Col. 3: Need to IV for %black and %opp_blackper
sort team edate
for X in num 1/10: by team: gen blackperX=blackper[_n-X]
egen blackperav=rmean(blackper1-blackper10)
sort opp_team edate
for X in num 1/10: by opp_team: gen opp_blackperX=opp_blackper[_n-X]
egen opp_blackperav=rmean(opp_blackper1-opp_blackper10)
gen ivbl_fw=blackperav*fracwhite
gen ivopp_bl_fw=opp_blackperav*fracwhite
gen diff_blackperav=blackperav-opp_blackperav
gen diff_blackperav_fw=fracwhite*diff_blackperav
gen diff_ivbl_fw=(blackperav-opp_blackperav)*fracwhite



** Fouls
reg fouls bl_fw opp_bl_fw blackper opp_blackper $teamgame_controls $oppgame_controls t_* o_* rid* yr_* , cluster(gameid)
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') replace

reg fouls bl_fw opp_bl_fw blackper opp_blackper $teamgame_controls $oppgame_controls t_* o_* rid* yr_* xn_*  htb_* hoy_* ty_* oy_* , cluster(gameid) 
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') append

ivreg fouls (bl_fw opp_bl_fw blackper opp_blackper = ivbl_fw ivopp_bl_fw blackperav opp_blackperav)  $teamgame_controls $oppgame_controls t_* o_* rid* yr_* xn_* htb_* hoy_* ty_* oy_* , cluster(gameid) first
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') append


** Points
reg points bl_fw opp_bl_fw blackper opp_blackper $teamgame_controls $oppgame_controls t_* o_* rid* yr_* , cluster(gameid)
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') append

reg points bl_fw opp_bl_fw blackper opp_blackper $teamgame_controls $oppgame_controls t_* o_* rid* yr_* xn_*  htb_* hoy_* ty_* oy_* , cluster(gameid) 
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') append

ivreg points (bl_fw opp_bl_fw blackper opp_blackper = ivbl_fw ivopp_bl_fw blackperav opp_blackperav)  $teamgame_controls $oppgame_controls t_* o_* rid* yr_* xn_* htb_* hoy_* ty_* oy_* , cluster(gameid) first
lincom bl_fw-opp_bl_fw
local pval=2*ttail($S_3,abs($S_1/$S_2))
test bl_fw opp_bl_fw
outreg bl_fw opp_bl_fw using "Results\Table6", se coefastr nocons 3aster adec(3) addstat(F test:bl_fw=opp_bl_fw=0, r(F), Prob>F, r(p), Difference: bl_fw-opp_bl_fw, $S_1, SE(diff), $S_2, p-value, `pval') append


** Wins
global controls1 "$teamgame_controls $oppgame_controls t_* o_* rid* yr_*"
sort gameid home
qui foreach v of varlist $controls1 {
	cap gen c1_`v'=`v'-`v'[_n-1]
}
global controls2 "$teamgame_controls $oppgame_controls t_* o_* rid* yr_* xn_* htb_* hoy_* ty_* oy_*"
qui foreach v of varlist $controls2 {
	cap gen c2_`v'=`v'-`v'[_n-1]
}

reg win diff_bl_fw diff_blackper c1_* if home==1							  
outreg diff_bl_fw using "Results\Table6", se coefastr nocons 3aster append

reg win diff_bl_fw diff_blackper c2_* if home==1							  
outreg diff_bl_fw c2_xn_coach_black using "Results\Table6", se coefastr nocons 3aster append

ivreg win (diff_bl_fw diff_blackper = diff_ivbl_fw diff_blackperav) c2_* if home==1, first 
outreg diff_bl_fw c2_xn_coach_black using "Results\Table6", se coefastr nocons 3aster append

* Interpret the column 1 result
reg win diff_bl_fw diff_blackper c1_* if home==1							  
global beta=_b[diff_bl_fw]

summ diff_bl_fw
global sd=r(sd)
di "1 SD shock to racial mismatch = " $sd

di "Effect on winning of one standard deviation shock= " $beta*$sd

gen adiff=abs(diff_blackper)
summ adiff
global adiff=r(mean)
di "Typically one team plays with " $adiff*100 "% more time given to black players"
di "Which changes the chances of victory by " $adiff*$beta*100 "% when comparing all black and all white crews"
di "or " $adiff*$beta*100/3 "% for a one referee change"

summ fracwhite
global whiterefs=r(mean)
summ blackper
global blackplayingtime=r(mean)
summ win if blackper>opp_blackper
di "Typically the team with the greater share of playing time accounted for by black players won " r(mean)*100 "% of the time"
di "Race-norming the ref crew would raise this by " $beta*$adiff*((1-$blackplayingtime)-$whiterefs)*100 "%"
di "Payroll consequences = " 100*$beta*$adiff*((1-$blackplayingtime)-$whiterefs)/.29 "% of the aggregate wage bill"

reg win bl_fw opp_bl_fw blackper opp_blackper $teamgame_controls $oppgame_controls t_* o_* rid* yr_* , cluster(gameid)
predict winhat
summ win [aw=blackstarter] /* Current black win % */
summ winhat [aw=blackstarter] 
replace winhat=winhat+$beta*((1-$blackplayingtime)-$whiterefs)*(blackper-opp_blackper)
summ winhat [aw=blackstarter]
replace winhat=winhat-$beta*((1-$blackplayingtime)-$whiterefs)*(blackper-opp_blackper)

summ win [aw=5-blackstarter] /* Current black win % */
summ winhat [aw=5-blackstarter] 
replace winhat=winhat+$beta*((1-$blackplayingtime)-$whiterefs)*(blackper-opp_blackper)
summ winhat [aw=5-blackstarter]
replace winhat=winhat-$beta*((1-$blackplayingtime)-$whiterefs)*(blackper-opp_blackper)


* Re-analyze wins, using a probit
dprobit win diff_bl_fw diff_blackper c1_* if home==1
dprobit win diff_bl_fw diff_blackper c2_* if home==1

