clear *
set mem 1200m
set more off
use individual_data if sample==1 & min>0, clear
xi i.year, prefix(yrs)

egen g=tag(gameid)

foreach v of varlist rid* {
	local w=substr("`v'",4,.)
	count if `v'==1
	if r(N)>0 {
		gen whiteref`v'=w1 if ref1_id==`w'
		replace whiteref`v'=w2 if ref2_id==`w'
		replace whiteref`v'=w3 if ref3_id==`w'
		tomode whiteref`v', replace
		tab whiteref`v'
		reg fouls_rate black $player_controls $playergame_controls $teamgame_controls $career_stats yr* if `v'==1 [aw=min]
		gen beta`v'=_b[black] if _se[black]~=.
		gen se`v'=_se[black]
		gen df`v'=e(df_r)
		count if `v'==1 & g==1
		gen games`v'=r(N)
	}
}

keep beta* se* games* whiteref* df*
gen n=1
keep if _n==1

reshape long betarid serid gamesrid whiterefrid dfrid, i(n) j(ref)
for ! in any beta se games whiteref df: rename !rid !
gen cil=beta+invttail(df,.975)*se
gen ciu=beta+invttail(df,.025)*se

summ beta [w=games]
global m=r(mean)
egen r=rank(beta) if games>=100
reg beta if whiteref==1 [w=games]
global w=_b[_cons]
global sew=_se[_cons]
reg beta if whiteref==0 [w=games]
global b=_b[_cons]
global seb=_se[_cons]
count if beta>$w & whiteref==0 & games>=100
count if whiteref==0 & games>=100
count if beta<$b & whiteref==1 & games>=100
count if whiteref==1 & games>=100
global w=string(round($w, .001), "%9.3f")
global b=string(round($b,.001), "%9.3f")
tab whiteref if beta>$b

#delimit ;
twoway
	(rcap ciu cil r if whiteref==1, lcolor(purple) lpattern(shortdash) lwidth(vthin))
	(rcap ciu cil r if whiteref==0, lcolor(navy) lpattern(solid) lwidth(vthin))
	(scatter beta r if whiteref==1, msymbol(circle_hollow) mcolor(purple))
	(scatter beta r if whiteref==0, msymbol(square) mcolor(navy))
	if games>=100 
,
	yline(0, lcolor(black) lwidth(vvthin))
	xlabel(, noticks nolabels)
	xtitle("Referee-specific estimate of racial bias in foul-calling (sorted)")
	ytitle("Extra fouls awarded against black players (per 48 minutes)")
	ylabel(-.6(.2).6, angle(horizontal))
	legend(
		order(3 "White Referees" "Game-weighted ave.=$w" 4 "Black Referees" "Game-weighted ave.=$b")
		region(fcolor(none)) pos(6) ring(0)
	)
	xsize(10) ysize(7.5)
	name(distribution2, replace)
	saving(Results\Fig2, replace)
;
#delimit cr
graph export Results\Fig2.eps, replace



