*Table 2. Independence

clear *
set more off

cap log close
log using logs\randomization.log, replace

set mem 400m
set matsize 1000
set more off
use team_data if sample==1

drop if fracwhite==. | home_attend==. | out_cont==.
replace coachid=-999 if coachid==.
replace opp_coachid=-999 if opp_coachid==.

table year white, c(m blackstarter) format(%9.2f)
tab white if blackstarter+year~=.
bys year: tab white blackstarter, chi2 nofreq


* Appendix table on randomization
keep if home==1
xi i.year, prefix("y")
xi i.team, prefix("htm")
xi i.opp_team, prefix("atm")
xi i.year*i.team, prefix("ty")
drop tyyear*
drop tyteam*
xi i.year*i.opp_team, prefix("oy")
drop oyyear*
drop oyopp_team*

reg white yyear*
testparm yyear*

reg white yyear* blackstarter opp_blackstarter
for ! in any yy* blackstarter opp_blackstarter: testparm ! \  di "Indep var !: p-val=" round(r(p),.01)
testparm blackstarter opp_blackstarter
di "Marginal vars: p-val=" round(r(p),.01)
testparm blackstarter opp_blackstarter
di "All vars ex. year FE=" round(r(p),.01)

reg white yyear* blackstarter opp_blackstarter attend out_cont opp_out_cont
noi for ! in any yy* blackstarter opp_blackstarter attend out_cont opp_out_cont: testparm ! \  di "Indep var !: p-val=" round(r(p),.01)
testparm attend out_cont opp_out_cont
di "Marginal vars: p-val=" round(r(p),.01)
testparm blackstarter opp_blackstarter attend out_cont opp_out_cont
di "All vars ex. year FE=" round(r(p),.01)

reg white yyear* blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm*
for ! in any yy* blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm*: testparm ! \  di "Indep var !: p-val=" round(r(p),.01)
testparm htm* atm*
di "Marginal vars: p-val=" round(r(p),.01)
testparm blackstarter blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm*
di "All vars ex. year FE=" round(r(p),.01)

reg white yyear* blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm* ty* oy*
for ! in any yy* blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm* ty* oy*: testparm ! \  di "Indep var !: p-val=" round(r(p),.01)
testparm ty* oy*
di "Marginal vars: p-val=" round(r(p),.01)
testparm blackstarter opp_blackstarter attend out_cont opp_out_cont htm* atm* ty* oy*
di "All vars ex. year FE=" round(r(p),.01)

