insheet using "AllDerivs(ForStata).csv", clear
* Calculated statistics on Auction distributions assume that the tail bins are of zero width.  Thus calculate directly.
drop amean amedian astd
* Decode the dates
gen dtauction=date(auctiondate, "mdy")
gen dtrelease=date(releasedatetime, "mdy")
* Rescale things to lie between 0 and 100
for var prob*: replace X=X/100
* Compute median
gen cum1=probbin1
qui for X in num 2/18 \ Y in num 1/17: gen cumX=cumY+probbinX
gen amedian=.
qui for X in num 2/18 \ Y in num 1/17: replace amedian=binubY+((0.5-cumY)/probbinX)*(binubX-binubY) if cumY<.5 & cumX>=.5
drop cum*
la var amedian "Auction median, calculated"
* To bound the extreme bins, we will find the upper or lower limit so that the mean of the unbounded distribution = the median of the bounds
egen leftbin=rmin(binub*)
la var leftbin "Upper bound of leftmost bin"
gen left=releasedvalue<leftbin
la var left "Released value in left tail"
gen leftprob=.
qui for num 1/18: replace leftprob=probbinX if binubX==leftbin
la var leftprob "Probability in left tail"
gen double integral=0
gen double dx=.
gen double x=.
scalar leftlimit=-10
forvalues i=0(1)1000 {
	quietly replace x=leftlimit+`i'*(invnorm(leftprob)-leftlimit)/1000
	quietly replace dx=(invnorm(leftprob)-leftlimit)/1000
	quietly replace integral=integral+dx*normden(x)*x
}
replace integral=integral/leftprob
gen leftbinmean=amed+integral*(leftbin-amed)/invnorm(leftprob)
la var leftbinmean "Mean of left tail; assuming normality"
replace binlb1=leftbin+2*(leftbinmean-leftbin)

egen rightbin=rmax(binlb*)
la var rightbin "Lower bound of rightmost bin"
gen right=releasedvalue>rightbin
la var right "Released value in right tail"
gen rightprob=.
qui for num 1/18: replace rightprob=probbinX if binlbX==rightbin
la var rightprob "Probability in right tail"
replace integral=0
scalar rightlimit=10 /*This is the limit of integration; effectively infinity*/
forvalues i=0(1)1000 {
	quietly replace x=rightlimit+`i'*(-rightlimit+invnorm(1-rightprob))/1000
	quietly replace dx=(rightlimit-invnorm(1-rightprob))/1000
	quietly replace integral=integral+dx*normden(x)*x
}
replace integral=integral/rightprob
gen rightbinmean=amed+integral*(rightbin-amed)/invnorm(1-rightprob)
la var rightbinmean "Mean of right tail; assuming normality"
qui for num 1/18: replace binubX=rightbin+2*(rightbinmean-rightbin) if binlbX==rightbin
drop x dx integral

* Compute means
qui for num 1/18: gen midX=(binlbX+binubX)/2
qui for num 1/18: gen contX=midX*probbinX
egen amean=rsum(cont*)
drop mid* cont*
la var amean "Auction mean, taking account of mass in the tails"
* Note that my mean approx= forward price + 0.6*astd*(rightprob-leftprob)

* Compute standard deviation
gen astd=0
quietly for num 1/18: replace astd=astd+probbinX*((binubX+binlbX)/2-amean)^2 if probbinX~=.
replace astd=astd^0.5
la var astd "Auction standard deviation, calculated"

* Set panel variables
egen statno=group(statistic)
egen startdate=min(dtrelease), by(statistic)
gen time=1+round((dtrelease-startdate)/30.5,1) if statistic~="iclm"
replace time=1+round((dtrelease-startdate)/7,1) if statistic=="iclm"
tsset statno time

* Generate useful labels
gen str20 stat=""
for X in any iclm napm nfpay rsxaut \ Y in any "Initial Unemployment Claims" "Business Confidence (ISM)" "Non-Farm Payrolls"  "Retail Sales (ex Autos)": replace stat="Y" if statistic=="X"
la var stat "Economic data series"

for any a m: gen Xmeanerr=releasedvalue-Xmean 
for any a m: gen Xmederr=releasedvalue-Xmedian

la var ameanerr "Auction Mean - Released value"
la var mmeanerr "Survey Mean - Released value"
la var amederr "Auction Median - Released value"
la var mmederr "Survey Median - Released value"
save "AllDerivatives", replace

*Do the scaling using historical forecast error standard deviations.
*Data from 1990 to the start of my sample.
*Historical standard errors for the four statisctics are:
*NFPAY:115.8549
*NAPM: 1.990284
*RSXAUT: 0.3687942
*ICLM: 18.57478

qui for X in var releasedval amean mmean amedian mmedian mstd astd ameanerr mmeanerr amederr mmederr binub* binlb*: replace X=X/18.57478 if statistic=="iclm" \ replace X=X/1.990284 if statistic=="napm" \ replace X=X/115.8549 if statistic=="nfpay" \ replace X=X/0.3687942 if statistic=="rsxaut"
save "AllDerivatives(scaled)", replace

