#delimit;
version 5.0;
set more off;
set matsize 400;

/*areg is used throught this program, adding the fixed effect into prediction*/

/* (0) Data set Cpcounty5.dta should be used to run this do file*/

/* (1)This program uses the average probability of being given a death row sentence. This is defined as the total number of death row sentences in the given state in years t + t-1 divided by the total number of arrests for murder in the given state in years t-2 + t-3*/ 

/* (2) This program was used to generate predicted sentencing rate to be used in the second stage of the 2SLS.  To store the predicted sentencing rates in the data set Cpcounty5, calling them PSENTAP2.  These predictions includes the fixed effects; the procedure for adding the fixed effects to predicted values was given to us by Sribney, senior statisticians at Stata.*/  

/*THE DATA on death penalty sentences was collected from Tracy Snell at the BJS.  She gave us the data from the most current database, because often the data reported in "Capital Punishment, 19**" publications are inaccurate because the relevant agencies have not informed the BJS of all the death penalty sentences before the publication goes out.  The data on executions was collected from the BJS's "Sourcebook of Criminal Justice Statistics" published annually*/


/* FOR PSENTA*/

areg  PSENTA POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM IYEAR_78-IYEAR_96 [aweight=POPC], absorb(COUNTY);



predict double yhat;
egen double A=sum(POPC*yhat) if yhat~=., by(COUNTY);
egen double B=sum(POPC), by(COUNTY);
egen double C=sum(POPC*PSENTA) if PSENTA~=., by(COUNTY);
generate double yhatbari=A/B;
generate double ybari=C/B;
generate PSENTAP2 =yhat-yhatbari+ybari;
drop A B C yhat yhatbari ybari;

