#delimit;
version 5.0;
set more off;
set matsize 400;

/* The arrest rate (PAMURC) is defined as number of arrests for murders divided by numbers of arrest in the county 100.  Because there are several counties that have no murders for some years, this figure generated many missing values.  In order to no eliminate these counties from the regression analysis we did the following: if PAMURC was missing because the number of murders = 0 and the number of arrests was not a missing value, then PAMURC was replaced with PAMURC from the most recent year in which this was not the case.  The intuition behind this is that if a criminal sees no murders in his county in a year he can not form a prediction of the probability of arrest if he commits a murder.  Therefore, he looks to the last year in which there was a murder so he can form a prediction of the probability of being arrested.  Especially in small towns which is where the murder rate would often be 0, a murder and the accompanying arrest is remembered for a long time.  We continued this process back for 6 years.  So if there was no murder in year t, a potential murderer looks back at all the years until t-6 to form a prediction of the probability of arrest based on the probability associated with the most recent murder*/

/*PAMURC*/
sort COUNTY YEAR;
replace PAMURCL=PAMURC[_n-1] if COUNTY==COUNTY[_n-1];
sort COUNTY YEAR;
replace PAMURCL2=PAMURCL[_n-1] if COUNTY==COUNTY[_n-1];
sort COUNTY YEAR;
replace PAMURCL3=PAMURCL2[_n-1] if COUNTY==COUNTY[_n-1];
sort COUNTY YEAR;
replace PAMURCL4=PAMURCL3[_n-1] if COUNTY==COUNTY[_n-1];
sort COUNTY YEAR;
generate PAMURCL5=PAMURCL4[_n-1] if COUNTY==COUNTY[_n-1];
sort COUNTY YEAR;
generate PAMURCL6=PAMURCL5[_n-1] if COUNTY==COUNTY[_n-1];

replace PAMURC=99999 if PAMURC==. & AMUR~=. & MURDO1==0;
replace PAMURC=PAMURCL if PAMURC==99999 & PAMURCL~=.;
replace PAMURC=PAMURCL2 if PAMURC==99999 & PAMURCL2~=.;
replace PAMURC=PAMURCL3 if PAMURC==99999 & PAMURCL3~=.;
replace PAMURC=PAMURCL4 if PAMURC==99999 & PAMURCL4~=.;
replace PAMURC=PAMURCL5 if PAMURC==99999 & PAMURCL5~=.;
replace PAMURC=PAMURCL6 if PAMURC==99999 & PAMURCL6~=.;
replace PAMURC=. if PAMURC==99999;
drop PAMURCL PAMURCL2 PAMURCL3 PAMURCL4;


